# test_config.py - FIND YOUR MYSQL CONFIGURATION
import mysql.connector
from mysql.connector import Error

def find_mysql_config():
    print("🔍 Finding your MySQL configuration...")
    print("=" * 50)
    
    # Common MySQL configurations to try
    configs_to_try = [
        # Default configurations
        {'host': 'localhost', 'user': 'root', 'password': ''},
        {'host': 'localhost', 'user': 'root', 'password': 'root'},
        {'host': 'localhost', 'user': 'root', 'password': 'password'},
        {'host': 'localhost', 'user': 'root', 'password': '123456'},
        {'host': '127.0.0.1', 'user': 'root', 'password': ''},
        
        # XAMPP default
        {'host': 'localhost', 'user': 'root', 'password': '', 'port': 3306},
        
        # WAMP default
        {'host': 'localhost', 'user': 'root', 'password': '', 'port': 3306},
        
        # MAMP default (Mac)
        {'host': 'localhost', 'user': 'root', 'password': 'root', 'port': 8889},
    ]
    
    successful_configs = []
    
    for config in configs_to_try:
        try:
            print(f"Trying: {config['user']}@{config['host']}:{config.get('port', 3306)}")
            
            connection = mysql.connector.connect(
                host=config['host'],
                user=config['user'],
                password=config['password'],
                port=config.get('port', 3306),
                auth_plugin='mysql_native_password'
            )
            
            if connection.is_connected():
                db_info = connection.get_server_info()
                cursor = connection.cursor()
                cursor.execute("SELECT DATABASE()")
                current_db = cursor.fetchone()
                
                print(f"✅ SUCCESS! MySQL {db_info}")
                print(f"   Current database: {current_db[0]}")
                
                # Show databases
                cursor.execute("SHOW DATABASES")
                databases = [db[0] for db in cursor.fetchall()]
                print(f"   Available databases: {', '.join(databases)}")
                
                successful_configs.append(config)
                cursor.close()
                connection.close()
                
        except Error as e:
            print(f"❌ Failed: {e}")
    
    print("\n" + "=" * 50)
    if successful_configs:
        print("🎉 SUCCESSFUL CONFIGURATIONS FOUND:")
        for i, config in enumerate(successful_configs, 1):
            print(f"{i}. Host: {config['host']}")
            print(f"   User: {config['user']}")
            print(f"   Password: {'[empty]' if config['password'] == '' else config['password']}")
            print(f"   Port: {config.get('port', 3306)}")
            print()
    else:
        print("❌ No successful connections. Please check:")
        print("1. Is MySQL installed and running?")
        print("2. Try starting MySQL service:")
        print("   - Windows: Run 'services.msc' and start MySQL")
        print("   - Linux/Mac: 'sudo service mysql start'")
        print("3. Install MySQL from: https://dev.mysql.com/downloads/installer/")

if __name__ == "__main__":
    find_mysql_config()